<?php

namespace cnb\admin\domain;

// don't load directly
defined( 'ABSPATH' ) || die( '-1' );

use cnb\admin\api\CnbAppRemote;
use cnb\admin\domain\CnbDomainViewUpgradeOverview;
use cnb\notices\CnbAdminNotices;
use cnb\notices\CnbNotice;
use cnb\utils\CnbUtils;

class CnbDomainViewUpgradeFinished {

    /**
     * @return string
     */
    private function get_settings_url() {
        $url      = admin_url( 'admin.php' );
        $tab_link =
            add_query_arg(
                array(
                    'page' => 'call-now-button-settings'
                ),
                $url );

        return esc_url( $tab_link );
    }

    /**
     * @return string
     */
    private function get_button_overview_url() {
        $url = admin_url( 'admin.php' );

        return add_query_arg(
            array(
                'page' => 'call-now-button',
            ),
            $url );
    }
    /**
     * Print Cloud benefits
     *
     * @return void
     */
    private function renderBenefits() {
        echo '<div>';
        echo '<h1 class="cnb-center top-50"><strong>Other features include:</strong></h1><hr>';
        ( new CnbDomainViewUpgradeOverview() )->renderBenefits();
        echo '</div>';
    }

    private function renderLetsGo() {
        $portal_url = CnbAppRemote::cnb_remote_create_billing_portal();
        echo sprintf( '
            <div class="cnb-get-started cnb-plan-features cnb-center top-50">
            <h1 class="cnb-center"><strong>Let\'s get started</strong></h1><hr>
            <div class="cnb-flexbox">
              <div class="box">
                <h2>Manage your buttons</h2>
                <p>
                  <a class="button premium-button" href="%1$s">Button overview</a>
                </p>
              </div>
              <div class="box">
                <h2>Check your Settings</h2>
                <p><a class="button premium-button" href="%2$s">Open settings
                  </a></p>
              </div>
              <div class="box">
                <h2>Administration</h2>
                <p><a class="button premium-button" href="%3$s">Invoices</a></p>
              </div>
            </div>
            </div>',
            esc_url( $this->get_button_overview_url() ),
            esc_url( $this->get_settings_url() ),
            esc_url( $portal_url->url )
          );
    }

    /**
     * print SVG wrapped in a div with a big, nice and pretty "Yay!"
     *
     * @return void
     */
    public function echoBigYaySvg() {
        echo '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 561 309"><path d="M107.373,301.9a109.773,109.773,0,0,0,19.32-5.52,155.59,155.59,0,0,0,36.6-20.16,121,121,0,0,0,30.12-31.44q18.477-.241,34.68-0.96t25.08-4.32q9.837-4.083,14.04-10.44t4.2-11.4a10.559,10.559,0,0,0-.12-1.68,10.242,10.242,0,0,0-.36-1.44q-1.2-3.841-2.16-3.84-0.72,0-.72,2.16v1.44q0,6.959-3.96,10.2a92.727,92.727,0,0,1-11.88,7.8q-6.723,3.837-21.96,5.04t-33,1.2a290.972,290.972,0,0,0,12.84-27.48q6.356-15.48,12-32.4t10.2-33.36q4.555-16.435,7.68-30.36,2.16-9.837,2.16-14.64t-1.32-6.72a3.863,3.863,0,0,0-3.24-1.92q-2.88,0-6,2.88t-3.6,5.04q-2.16,7.443-6.24,18.48t-9.84,23.64q-5.76,12.6-12.96,24.96a184.347,184.347,0,0,1-15.48,22.68,84.992,84.992,0,0,1-17.16,16.56q-11.284,7.92-21.36,7.92a14.461,14.461,0,0,1-10.32-3.84q-4.085-3.836-4.08-12.24,0-1.917.24-4.32a48.082,48.082,0,0,1,.72-4.8,149.376,149.376,0,0,1,8.16-24.96q5.76-13.916,13.56-28.8t15.96-28.56a174.627,174.627,0,0,0,14.16-30.12,87.036,87.036,0,0,0,5.52-29.16,46.691,46.691,0,0,0-5.28-22.2q-5.283-9.956-18-15.48a41.469,41.469,0,0,0-11.52-3.72,77.4,77.4,0,0,0-13.2-1.08q-16.083,0-34.32,6.12a162.671,162.671,0,0,0-35.88,17.4,176.481,176.481,0,0,0-32.28,26.52A129.268,129.268,0,0,0,14.853,88.3a108.621,108.621,0,0,0-6.96,18.6,70.9,70.9,0,0,0-2.4,18.36q0,15.363,6.48,26.64a46.526,46.526,0,0,0,16.92,17.4,43.619,43.619,0,0,0,22.44,6.12,45.766,45.766,0,0,0,17.76-3.6,82.446,82.446,0,0,0,27.12-17.64,88.512,88.512,0,0,0,17.4-23.52q6.12-12.357,6.12-22.44,0-8.64-4.56-14.16t-14.4-5.52a51.739,51.739,0,0,0-11.76,1.68,6.733,6.733,0,0,0-3.12,1.32q-1.44,1.08-1.44,1.56,0,0.962,2.16.96h1.2a6.994,6.994,0,0,0,1.68-.24,29.9,29.9,0,0,1,6.24-.72q7.92,0,11.4,4.44t3.48,11.4a46.527,46.527,0,0,1-3.12,15.6,78.488,78.488,0,0,1-8.76,17.04,83.89,83.89,0,0,1-12.96,15.12,44.622,44.622,0,0,1-15.72,9.6,46.932,46.932,0,0,1-15.36,2.64,36.88,36.88,0,0,1-17.52-4.32,33.31,33.31,0,0,1-13.2-12.84q-5.04-8.516-5.04-21.48a73.287,73.287,0,0,1,2.04-16.32,119.309,119.309,0,0,1,6.36-19.2,125.152,125.152,0,0,1,19.68-31.44,165.561,165.561,0,0,1,28.92-27,156.037,156.037,0,0,1,33.24-18.84q17.037-6.958,32.4-6.96,14.4,0,24.96,6.72a16.293,16.293,0,0,1,6.6,8.28,34.892,34.892,0,0,1,2.04,12.36,85.436,85.436,0,0,1-3.12,21.12,162.259,162.259,0,0,1-8.88,24.96,215.654,215.654,0,0,1-13.44,25.44q-6.48,10.8-14.04,24.36a280.918,280.918,0,0,0-13.44,27.48,112.986,112.986,0,0,0-7.8,25.92q-0.243,1.683-.36,3.36c-0.083,1.122-.12,2.16-0.12,3.12q0,13.923,7.92,20.4a28.988,28.988,0,0,0,18.96,6.48q14.877,0,28.8-9.36a95.478,95.478,0,0,0,20.64-19.32,189.687,189.687,0,0,0,16.56-24.12,232.159,232.159,0,0,0,11.52-22.32q-6.48,24-14.88,47.04t-17.76,46.32a523.566,523.566,0,0,0-54.48,2.76,175.855,175.855,0,0,0-49.92,12.6q-15.362,6.239-22.2,13.92t-6.84,14.16q0,8.877,10.44,15.12t27.24,6.24A97.719,97.719,0,0,0,107.373,301.9Zm-34.08-8.16q-7.324-3.122-7.32-8.4,0-4.083,4.68-9.36t15.48-11.28a130.694,130.694,0,0,1,46.56-16.2,334.727,334.727,0,0,1,49.44-3.72,101.744,101.744,0,0,1-27,28.92,137.241,137.241,0,0,1-32.28,17.4,95.658,95.658,0,0,1-16.08,4.32,87.429,87.429,0,0,1-15.12,1.44Q80.611,296.863,73.293,293.743ZM429.57,163.9q-6.245,12.483-11.16,21a75.586,75.586,0,0,1-10.8,14.64,60.436,60.436,0,0,1-14.28,10.8,156.273,156.273,0,0,1-21.36,9.48q-5.76,10.317-13.08,21.48a148.749,148.749,0,0,1-16.56,20.88,83.473,83.473,0,0,1-20.4,15.84,50.308,50.308,0,0,1-24.6,6.12q-12.477,0-17.76-4.92a15.412,15.412,0,0,1-5.28-11.64,18.313,18.313,0,0,1,.96-6.24q0.962-2.643,2.88-6.72a35.934,35.934,0,0,1,9.36-12,55.137,55.137,0,0,1,12.96-8.16,142.837,142.837,0,0,1,28.44-9.36q15.957-3.6,30.6-7.92a124.05,124.05,0,0,0,8.4-18.12q3.836-10.2,6.96-19.92t5.04-15.96q-2.88,5.283-7.32,12.84a145.514,145.514,0,0,1-9.96,14.76,62.714,62.714,0,0,1-11.88,12,21.791,21.791,0,0,1-13.32,4.8,21.187,21.187,0,0,1-6.36-1.2,14.088,14.088,0,0,1-6.48-4.44q-2.763-3.24-2.76-9.72a26.341,26.341,0,0,1,3-12.12c1.191-2.336,2.327-4.617,3.434-6.869-0.6,1.142-1.224,2.308-1.872,3.509a169.966,169.966,0,0,1-8.88,14.64,65.146,65.146,0,0,1-9.96,11.76q-5.163,4.68-10.44,5.16a12.548,12.548,0,0,1-6-1.2,13.526,13.526,0,0,1-5.88-5.28q-2.52-3.836-2.52-10.8a55.888,55.888,0,0,1,2.16-13.92q-2.88,4.563-7.44,11.16a74.782,74.782,0,0,1-9.84,11.64,34.073,34.073,0,0,1-8.64,6.24,17.655,17.655,0,0,1-7.44,1.92q-6.243,0-10.08-5.64t-3.84-14.76q0-9.6,4.8-21.84t15.6-25.44a53.97,53.97,0,0,1,16.92-13.56,42.337,42.337,0,0,1,19.56-5.16,31.164,31.164,0,0,1,10.56,1.8,22.469,22.469,0,0,1,8.88,5.88,5.3,5.3,0,0,1,1.68,3.84,2.954,2.954,0,0,1-1.2,2.4,3.412,3.412,0,0,1-3.12.48q-2.643-8.4-11.28-8.4a21.446,21.446,0,0,0-9.36,2.64q-8.162,4.32-16.92,14.16a144,144,0,0,0-15.24,20.4,59.659,59.659,0,0,0-3,5.52q-2.041,4.084-3.96,9.12a47.329,47.329,0,0,0-2.64,9.84,14.3,14.3,0,0,0-.24,2.04v1.8q0,7.92,6,7.92,7.2,0,16.32-10.56a138.065,138.065,0,0,0,11.28-16.08q5.04-8.4,10.32-18a109.441,109.441,0,0,1,6.72-10.8,10.3,10.3,0,0,1,8.88-4.32,20.007,20.007,0,0,1,5.28.72,12.723,12.723,0,0,0,5.52.24,42.9,42.9,0,0,0-5.16,7.2q-3.24,5.283-6.84,12t-6.48,13.68a82,82,0,0,0-4.08,12q-0.242,1.44-.6,4.08a32.118,32.118,0,0,0-.36,3.84q0,6.723,3.84,6.72t8.28-4.56a71.612,71.612,0,0,0,8.76-11.28q4.32-6.716,7.92-13.56t5.76-11.16a4.008,4.008,0,0,1,1.5-2.013c0.487-.979.953-1.979,1.373-3.027q3.6-7.436,7.2-14.28t6.24-12.12q2.637-5.276,9.12-5.28h14.88q-1.683,1.44-4.2,3.24a17.671,17.671,0,0,0-4.68,5.4q-6.48,11.043-11.28,21.24t-10.32,21.72a57.607,57.607,0,0,0-3.84,10.08,31.653,31.653,0,0,0-1.2,7.92q0,7.92,5.28,7.92,5.76,0,13.92-9.36a162.607,162.607,0,0,0,13.56-18.84q6.84-10.917,13.2-22.56t11.16-21.48q2.637-5.276,9.36-5.28h13.2a31.662,31.662,0,0,0-10.68,12.48q-3.725,7.684-8.28,19.68-5.04,13.2-9.48,27.24t-9.96,28.2a108.823,108.823,0,0,0,17.88-8.16,49.041,49.041,0,0,0,16.92-15.84,164.176,164.176,0,0,0,9.48-15.72q3.96-7.56,5.64-10.92c0.637-1.6,1.518-2.4,2.64-2.4s1.68,0.72,1.68,2.16A5.964,5.964,0,0,1,429.57,163.9ZM329.13,231.7a165.51,165.51,0,0,0-24.36,8.28,42.165,42.165,0,0,0-18.12,13.68q-6.6,8.877-6.6,15.84a9.6,9.6,0,0,0,2.76,7.08q2.762,2.757,8.76,2.76,7.92,0,16.32-4.8a89.765,89.765,0,0,0,16.32-12.12,195.3,195.3,0,0,0,14.52-14.88q6.6-7.56,10.68-13.32a43.594,43.594,0,0,0,2.64-4.32q1.44-2.643,2.88-5.04Q343.167,227.98,329.13,231.7Zm139.916-60.36q5.159-7.677,12.36-18.24t15.36-22.44q8.157-11.88,16.08-23.76t14.52-21.84q6.6-9.956,10.8-16.56t4.68-8.28l-0.48-1.2-1.2-.72h-7.68a34.313,34.313,0,0,0-7.2.72,7.142,7.142,0,0,0-5.04,4.08l-61.44,116.88-0.24,1.44,2.4,0.48Q463.885,179.023,469.046,171.343Zm-11.04,36.24a11.089,11.089,0,0,0,3.72-8.16,7.76,7.76,0,0,0-2.4-5.88,8.7,8.7,0,0,0-6.24-2.28,12.445,12.445,0,0,0-7.44,2.64,9.635,9.635,0,0,0-4.08,6.96,10.481,10.481,0,0,0,1.56,7.2q2.037,3.117,6.6,3.12A11.656,11.656,0,0,0,458.006,207.583Z"/></svg>';
    }

    /**
     * @param $domain CnbDomain
     * @param $notice CnbNotice
     *
     * @return void
     */
    function render( $domain, $notice = null ) {
        if($domain->type != 'PRO') {
          echo '<p>Your domain <strong>' . esc_html( $domain->name ) . '</strong> ';
          echo 'is currently on the <code>' . esc_html( $domain->type ) . '</code> cloud plan.</p>';
        }

        // Render notice if JUST upgraded and show general information about domain (instead of upgrade form)
        if ( $notice ) {
            CnbAdminNotices::get_instance()->renderNotice( $notice );
            // Big "Yay!"
            echo '<h1 class="cnb-upgrade-title"><span style="text-transform:uppercase">' . esc_html( $domain->name ) . '</span> is now a PRO domain!</h1>';
            echo '<div style="width:200px; height:auto; margin:0 auto">';
            $this->echoBigYaySvg();
            echo '</div>';
            echo '<div class="cnb-pricebox">';
            echo '<div class="cnb-benefit">✨ All "Powered by" notices are removed! ✨</div>';
            echo '<div class="cnb-benefit">⚡ Create slide-in Content Windows ⚡</div>';
            echo '<div class="cnb-benefit">📷 Use custom images on buttons 📷</div>';
            echo '<div class="cnb-benefit">🌍 You can include and exclude countries 🌍</div>';
            echo '<div class="cnb-benefit">↕️ Set scroll depth (buttons appear after scrolling) ↕️</div>';
            echo '<div class="cnb-benefit">🔌 Include Intercom Chat via our integration 🔌</div>';
            echo '</div>';

            $this->renderLetsGo();
            $this->renderBenefits();
        }


        echo '<p>';
        if ( ! empty( $domain->expires ) ) {
            echo 'Your subscription will';
            echo $domain->renew == 1 ? ' renew automatically ' : ' expire ';
            echo 'on ' . esc_html( date( 'F d, Y', strtotime( $domain->expires ) ) ) . '.';
        }

    }
}
